package com.huawei.android.powerkit.adapter;

import com.huawei.android.powerkit.adapter.IStateSink;

/** @hide */
interface IPowerKitApi
{
    /**
     * get Powerkit version
     */
    String getPowerKitVersion(String pkg);

    /**
     * get current resolution ratio of the calling application
     * @param pkg the pkg of the calling application
     * @return current resolution ratio of the calling application
     */
    float getCurrentResolutionRatio(String pkg);

    /**
     * get current fps of the calling application
     * @param pkg the pkg of the calling application
     * @return the fps to set of this application
     */
    int getCurrentFps(String pkg);

    /**
     * It is not necessary for the application to restart before new FPS become in effect
     * @param fps the fps to set, valid scope is [15, 60]
     * @return0 if set success, -1 if invalid param, -2 if aps service not ready, -3 if permission not allow
     */
    int setFps(String pkg, int fps);

     /**
     * Registers a sink with PG State-Recognition.
     */
    boolean registerSink(in IStateSink sink);

    /**
     * Unregisters a sink with PG State-Recognition.
     */
    boolean unregisterSink(in IStateSink sink);

    /**
     * Enables tracking of a given state, if the state is supported.
     */
    boolean enableStateEvent(in int stateType);

    /**
     * Disables tracking of a given state type.
     */
    boolean disableStateEvent(in int stateType);

    /**
     * apply for resource using.
     */
    boolean applyForResourceUse(String callingPkg, boolean apply, String module, int resourceType, long timeoutInMS, String reason);
    /**
     * which modules calling me when I am in power abnormal
     *
     * @param context The context of the caller.
     * @param module, module in power abnormal
     * @param callingModules, which modules calling me
     * @return {@code true} if successful,
     * else {@code false} if fail.
     * @hide
     */
    boolean notifyCallingModules(String callingPkg, String module, in List<String> callingModules);
}
